#include <stdio.h>
#include <time.h>

#include "../common/objects.h"
#include "../common/debug.h"
#include "../common/structs.h"
#include "../common/buffer.h"
#include "../common/colors.h"
#include "../common/misc.h"
#include "../common/vector.h"
#include "tracer.h"
#include "ray_common.h"
#include "sub_sample.h"
#include "../shader/post_shaders.h"
#include <stdlib.h>

extern scene_data* main_scene;
extern int intersects_calced;

void frameless_subsample_render()
{
	int i, x, y;
	int distance = main_scene->sub_dis;
	printd(DEBUG, "entering render loop\n");

//	flush_color_buffer();
	clear_idata_buffer();

	for(i=0; i<20; i++)
	{
//		//random points
//		x = (double)rand()/RAND_MAX * (main_scene->width - distance);
//		y = (double)rand()/RAND_MAX * (main_scene->height - distance);

		//grid points
		x = ((double)rand()/RAND_MAX) * (main_scene->width / distance);
		y = ((double)rand()/RAND_MAX) * (main_scene->height / distance);
		printd(CRAZY, "Sub-sample @  %i %i\n", x, y);
		calc_sub_sample(x * distance, y * distance, distance);
	}

	intersects_calced = 0;
}

void random_subsample_render()
{
	int i, x, y;
	int distance = main_scene->sub_dis;
	printd(DEBUG, "entering render loop\n");

//	flush_color_buffer();
	clear_idata_buffer();

	for(i=0; i<20; i++)
	{
		//random points
		x = (double)rand()/RAND_MAX * (main_scene->width - distance);
		y = (double)rand()/RAND_MAX * (main_scene->height - distance);

		printd(CRAZY, "Sub-sample @  %i %i\n", x, y);
		calc_sub_sample(x, y, distance);
	}

	run_post_shaders();
	intersects_calced = 0;
}
